# Keep it real

This repository contains the code and resources for Keep it real. The project aims to investigate the importance of realism in using learned image compression as an adversarial defense.

## Table of Contents
- [Overview](#overview)
- [Installation](#installation)
- [Weights](#weights)
- [Usage](#usage)

## Overview
This repository contains the code to recreate the experiments conducted for the paper: Keep It Real: Attacking Compression-Based
Adversarial Purification.
There are two requirement files, one called `requirements.txt` which covers the requirements for most of the codebase which works based on PyTorch and one called `requirements_mric.txt` which covers the requirements for the experiment using MRIC which is based on tensorflow.
There are several scripts made available which can be used to recreate the results shown in the paper.

## Installation
1. Clone the repository:
    ```bash
    git clone https://github.com/TODO.git
    ```
2. Install dependencies:
    ```bash
    pip install -r requirements.txt
    ```
    or 
    ```bash
    pip install -r requirements_mric.txt
    ```
3. Download the validation set of the ImageNet datset to data/val/
4. Download pre-trained weights for the Compression Models you want to use and move them to data/


## Weights
Download pre trained weights amove them to the data folder. We use:
CRDR: get the weights from https://github.com/iwa-shi/CRDR and move to /data/crdr.pth.tar
MRIC: get the weights from https://github.com/Nikolai10/MRIC , unzip and move to /data/MRIC we use the lambda = 0.128 weights
HiFiC: get the weights from https://github.com/Justin-Tan/high-fidelity-generative-compression and move to /data/hific_low.pt, /data/hific_med.pt or /data/hific_hi.pt , depending on which weights you want to use.
ELIC:  get the weights from https://github.com/VincentChandelier/ELiC-ReImplemetation and move them to /data/ELIC_0016_ft_3980_Plateau.pth.tar or /data/ELIC_XXXX_ft_3980_Plateau.pth.tar for different weights.

## Usage
There are some example scripts in the scripts folder. Running these scripts may take very long on a single GPU. We advise to divide the script and use multiple GPUs simultaneously.

If you want to run a single experiment run: "python run_experiment.py --args" the arguments are described in the run_experiments.py.

